<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Follow;

trait TraitUserFollowSetters
{
    use TraitUserFollowProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setFollowedUserId(string $followedUserId)
    {
        $this -> followedUserId = $followedUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setFollowedByUserId(string $followedByUserId)
    {
        $this -> followedByUserId = $followedByUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaIsPending(string $metaIsPending)
    {
        $this -> metaIsPending = $metaIsPending;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
